;; Setup Procedures
to setup
  ca
  cct bluemols
  [ set color blue
    randomize
  ]
  cct yellowmols
  [ set color yellow
    randomize
  ]
  ;; adjust the y-range of the plot to fit the number of molecules
  set-plot-y-range 0 max (list yellowmols bluemols)
end

to randomize
  set shape "circle"
  setxy random-float screen-size-x
        random-float screen-size-y
  rt random-float 360
end


;; Runtime Procedures

;; In GO, turtles move according to a number of different checks and
;;  procedures.  Note that all turtles must have executed the procedure
;;  CHECK-FOR-SPACE before any turtle can continue with CHECK-FOR-REACTION
;;  because they are broken up into two seperate ask blocks.  This ensures
;;  that every turtle will be on its own patch before any turtles checks for
;;  a reaction.
to go
  update-plot
  ask turtles
  [ fd 1 
    wiggle
    check-for-space
  ]
  ask turtles
  [ check-for-reaction ]
end

;; In WIGGLE, turtles are given a slight random twist to their heading.
to wiggle
  rt random-float 2
  lt random-float 2
end

;; In CHECK-FOR-SPACE, each turtle moves forward until it is alone in its
;;  own patch.  Note that the procedure calls itself if the check is true.
;;  This technique is called recursion.  CHECK-FOR-SPACE is called in GO.
to check-for-space
  if (count turtles-here > 1) 
  [ fd 1 check-for-space ]
end

;; In CHECK-FOR-REACTION, every turtle checks for a turtle it can react with within
;;  a radius which approximates the eight patches surrounding it.  Blue turtles can
;;  react with yellow turtles, and brown turtles can react with green turtles.
to check-for-reaction
  if color = blue and any? turtles in-radius 1 with [color = yellow]
  [ react-forward random-one-of turtles in-radius 1 with [color = yellow] ]
  if color = brown and any? turtles in-radius 1 with [color = green]
  [ react-reverse random-one-of turtles in-radius 1 with [color = green] ]
end

;; In REACT-FORWARD and REACT-REVERSE, the turtle changes the its color and the color
;;  of the turtle they are reacting with, sets a random heading, and jumps away to
;;  avoid further interaction.  They are the same except for their colors.
to react-forward [t]
  set color-of t brown
  set color green
  rt random-float 360
  jump 2
end

to react-reverse [t]
  set color-of t blue
  set color yellow
  rt random-float 360
  jump 2
end

;; In UPDATE-PLOT, each pen plots its corresponding turtle count.
to update-plot
  set-current-plot-pen "Yellows"
    plot count turtles with [color = yellow]
  set-current-plot-pen "Blues"          
    plot count turtles with [color = blue]
  set-current-plot-pen "Browns"
    plot count turtles with [color =  brown]
  set-current-plot-pen "Greens"
    plot count turtles with [color = green]
end


; *** NetLogo Model Copyright Notice ***
;
; This model was created as part of the project: CONNECTED MATHEMATICS:
; MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL
; MODELS (OBPML).  The project gratefully acknowledges the support of the
; National Science Foundation (Applications of Advanced Technologies
; Program) -- grant numbers RED #9552950 and REC #9632612.
;
; Copyright 1998 by Uri Wilensky. All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; This model was converted to NetLogo as part of the project:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN
; CLASSROOMS.  The project gratefully acknowledges the support of the
; National Science Foundation (REPP program) -- grant number REC #9814682.
; Converted from StarLogoT to NetLogo, 2001.  Updated 2002.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (1998).  NetLogo Chemical Equilibrium model.
; http://ccl.northwestern.edu/netlogo/models/ChemicalEquilibrium.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 1998 by Uri Wilensky.  All rights reserved.  See
; http://ccl.northwestern.edu/netlogo/models/ChemicalEquilibrium
; for terms of use.
;
; *** End of NetLogo Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
289
10
668
410
20
20
9.0
1
10
1
1
1
0

CC-WINDOW
5
424
677
519
Command Center

BUTTON
57
31
134
64
setup
setup
NIL
1
T
OBSERVER
T
NIL

BUTTON
152
31
228
64
go
go
T
1
T
OBSERVER
T
NIL

SLIDER
9
73
143
106
yellowmols
yellowmols
0
500
100
1
1
NIL

SLIDER
143
73
277
106
bluemols
bluemols
0
500
200
1
1
NIL

MONITOR
143
106
221
155
blues
count turtles with [color = blue]
3
1

MONITOR
65
106
143
155
yellows
count turtles with [color = yellow]
3
1

MONITOR
143
155
221
204
greens
count turtles with [color = green]
3
1

MONITOR
65
155
143
204
browns
count turtles with [color = brown]
3
1

PLOT
9
214
277
410
Concentrations
time
molecules
0.0
100.0
0.0
200.0
true
true
PENS
"Yellows" 1.0 0 -256 true
"Blues" 1.0 0 -16776961 true
"Greens" 1.0 0 -11352576 true
"Browns" 1.0 0 -6524078 true

@#$#@#$#@
WHAT IS IT?
-----------
This project shows how a simple chemical system comes to different equilibrium states depending on the concentrations of the initial reactants.  Equilibrium is the term we use to describe a system in which there are no macroscopic changes.  This means that the system "looks" like nothing is happening.  In fact, in all chemical systems microscopic processes continue but in a balance that yields no changes at the macroscopic level.  This model simulates two simple reactions of four molecules.   

The reactions can be written A + B yields C + D.  And at the same time, of course, C + D yields A + B.

A classic real-life example that would illustrate such reactions is the reactions of carbon monoxide with nitrous dioxide to produce carbon dioxide and nitrous monoxide.  The reverse is also possible.  All the reactants are gases.  We could watch such an equilibrium system because NO2 is a reddish colored gas which is visible. However, the combining of nitrous dioxide (NO2) with carbon monoxide (CO) results in the colorless products nitrous monoxide (NO) and carbon dioxide (CO2), and so the system loses its reddish color.  And yet, not all the color is lost. Ultimately the system comes to equilibrium with some of the "reactants" and some of the "products" present.

How much "reactant" and "product" a system ends up with depends on a number of factors.  The inherent kinetics of the reaction are of vital concern: For instance, some reactions tend to go in a particular direction because energy is released in that direction.  A system's equilibrium is also affected by the concentrations of the reactants -- this is modeled here -- and by the system's temperature.


HOW TO USE IT
-------------
As stated above, this model simulates a chemical system of four different molecules.  They are represented on the graphics screen as turtles of four different colors.  In this simulation, yellow molecules react with blue molecules to produce brown molecules and green molecules.  

The model is setup by first adjusting the YELLOWMOLS and BLUEMOLS sliders and pushing the SETUP button.  YELLOWMOLS sets how many yellow molecules the simulation starts with, while BLUEMOLS sets how many blue molecules the simulation starts with.


The GO button sets the simulation in motion.  Molecules move randomly and react with each other, changing color to represent rearrangement of atoms into different molecular structures.  The system soon comes into equilibrium.

Four monitors show how many of each kind of molecule are present in the system.  There is also a plot which plots the number of each kind of molecule present versus time.



THINGS TO NOTICE
----------------
Notice that the number of product molecules is limited by the smallest amount of reactant product.  Notice that there are always the same number of reactant products since they are formed in a one-to-one correspondence with each other. 


THINGS TO TRY
-------------
How do different amounts of the two reactants affect the final equilibrium.  Are absolute amounts important, is it the difference between the amounts, or is it a ratio of the two reactants that matters?  

Try setting the YELLOWMOLS slider to 400 and the BLUEMOLS slider to 20, 40, 100, 200, and 400 in five successive simulations.  What sort of equilibrium state do you predict in each case?  Are certain ratios predictable?


EXTENDING THE MODEL
-------------------
What if the forward and reverse reaction rates were the variables controlled instead of initial concentrations.  You could compare such a simulation with the one in this model and see if concentration and reaction rates act independently of each other, as measured by the final equilibrium state.  

You could also extend the program by allowing the user to introduce new molecules into the simulation while it is running.  How would the addition of fifty blue molecules affect a system that was already at equilibrium?


CREDITS AND REFERENCES
----------------------
To refer to this model in academic publications, please use: Wilensky, U. (2002). NetLogo Chemical Equilibrium model. http://ccl.northwestern.edu/netlogo/models/ChemicalEquilibrium. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

In other publications, please use: Copyright 2002 by Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/ChemicalEquilibrium for terms of use.
@#$#@#$#@
default
true
0
Polygon -7566196 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7566196 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7566196 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7566196 true true 150 285 285 225 285 75 150 135
Polygon -7566196 true true 150 135 15 75 150 15 285 75
Polygon -7566196 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7566196 true true 96 182 108
Circle -7566196 true true 110 127 80
Circle -7566196 true true 110 75 80
Line -7566196 true 150 100 80 30
Line -7566196 true 150 100 220 30

butterfly
true
0
Polygon -7566196 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7566196 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7566196 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7566196 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7566196 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7566196 true true 47 195 58
Circle -7566196 true true 195 195 58

circle
false
0
Circle -7566196 true true 30 30 240

circle 2
false
0
Circle -7566196 true true 16 16 270
Circle -16777216 true false 46 46 210

cow
false
0
Polygon -7566196 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7566196 true true 73 210 86 251 62 249 48 208
Polygon -7566196 true true 25 114 16 195 9 204 23 213 25 200 39 123

face happy
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7566196 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7566196 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7566196 true true 60 15 75 300
Polygon -7566196 true true 90 150 270 90 90 30
Line -7566196 true 75 135 90 135
Line -7566196 true 75 45 90 45

flower
false
0
Polygon -11352576 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7566196 true true 85 132 38
Circle -7566196 true true 130 147 38
Circle -7566196 true true 192 85 38
Circle -7566196 true true 85 40 38
Circle -7566196 true true 177 40 38
Circle -7566196 true true 177 132 38
Circle -7566196 true true 70 85 38
Circle -7566196 true true 130 25 38
Circle -7566196 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -11352576 true false 189 233 219 188 249 173 279 188 234 218
Polygon -11352576 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7566196 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7566196 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7566196 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7566196 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7566196 true 150 0 150 300

pentagon
false
0
Polygon -7566196 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7566196 true true 110 5 80
Polygon -7566196 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7566196 true true 127 79 172 94
Polygon -7566196 true true 195 90 240 150 225 180 165 105
Polygon -7566196 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7566196 true true 135 90 165 300
Polygon -7566196 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7566196 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7566196 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7566196 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7566196 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7566196 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7566196 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7566196 true true 30 30 270 270

square 2
false
0
Rectangle -7566196 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7566196 true true 60 270 150 0 240 270 15 105 285 105
Polygon -7566196 true true 75 120 105 210 195 210 225 120 150 75

target
false
0
Circle -7566196 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7566196 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7566196 true true 120 120 60

tree
false
0
Circle -7566196 true true 118 3 94
Rectangle -6524078 true false 120 195 180 300
Circle -7566196 true true 65 21 108
Circle -7566196 true true 116 41 127
Circle -7566196 true true 45 90 120
Circle -7566196 true true 104 74 152

triangle
false
0
Polygon -7566196 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7566196 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7566196 true true 4 45 195 187
Polygon -7566196 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7566196 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7566196 false true 24 174 42
Circle -7566196 false true 144 174 42
Circle -7566196 false true 234 174 42

turtle
true
0
Polygon -11352576 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -11352576 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -11352576 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -11352576 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -11352576 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7566196 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7566196 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7566196 true 150 285 150 15
Line -7566196 true 15 150 285 150
Circle -7566196 true true 120 120 60
Line -7566196 true 216 40 79 269
Line -7566196 true 40 84 269 221
Line -7566196 true 40 216 269 79
Line -7566196 true 84 40 221 269

x
false
0
Polygon -7566196 true true 270 75 225 30 30 225 75 270
Polygon -7566196 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 2.1beta4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
